<?php

namespace  App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model 
{

    protected $table = 'orders';
    public $timestamps = true;
    protected $fillable = array('client_id', 'notes', 'total_price', 'status', 'restaurant_id', 'delivery_charge', 'commission');

    public function client()
    {
        return $this->belongsTo(' App\Models\Client', 'city_id');
    }

    public function restaurant()
    {
        return $this->belongsTo(' App\Models\Restaurant', 'restaurant_id');
    }

    public function Products()
    {
        return $this->belongsToMany(' App\Models\Product', 'product_id')withPivot('price','quantity','special');
    }

}